/*
	ExtDLL test for Frontier WinLand

*/

#include <windows.h>
#include "FDllCall.h"

/*Given a string set each character to uppercase */
odbBool CALLBACK UpperCase (tydllparamblock * data, XDLLProcTable * proctable) {
	char * string;
	long len, i;
	Handle resStringH;
	char * resString;

	string = (char *) data->paramdata[0];
	len = data->paramsize[0];

	resStringH = (*(proctable->xMemAlloc)) (len);

	if (resStringH != NULL) {
		resString = (*(proctable->xMemLock)) (resStringH);

		for (i = 0; i < len; i++) {
			resString[i] = toupper (string[i]);
			}

		(*(proctable->xMemUnlock)) (resStringH);
		data->resultdata = (long) resStringH;
		data->resultsize = len;
		return (TRUE);
		}
	else
		{
		strcpy (data->errormessage, "Error allocating return buffer");
		}

	return (FALSE);
	}


typedef struct myInfoStruct {
	long count;
	long otherinfo;
	} myInfoStruct;

odbBool InitMyCount (XDLLProcTable * proctable, Handle * myInfo) {
	odbRef odb;
	odbValueRecord value;
	myInfoStruct * info;

	*myInfo = NULL;

	odb = (*(proctable->xOdbGetCurrentRoot)) ();

	if (odb != NULL) {
		if ((*(proctable->xOdbDefined)) (odb, "\x12" "user.myextdllvalue")) {
			/* we have already initialized it */
			if ((*(proctable->xOdbGetValue)) (odb, "\x12" "user.myextdllvalue", &value)) {
				*myInfo = value.data.binaryvalue;  /*return the handle*/
				return (TRUE);
				}
			}
		else
			{
			/*The first time */
			*myInfo = (*(proctable->xMemAlloc)) (sizeof(myInfoStruct));

			if (*myInfo != NULL) {
				info = (myInfoStruct *) (*(proctable->xMemLock)) (*myInfo);
				info->count = 0;  /* initialize the data */
				(*(proctable->xMemUnlock)) (*myInfo);

				/* now store this in the database for later usage */
				value.data.binaryvalue = *myInfo;
				value.valuetype = odb_longvaluetype;

				if ((*(proctable->xOdbSetValue)) (odb, "\x12" "user.myextdllvalue", &value)) {
					return (TRUE);
					}

				/* failed to save */
				(*(proctable->xMemFree)) (*myInfo);
				*myInfo = NULL;
				}                                                
			}
		}

	return (FALSE);
	}

odbBool CALLBACK Counter (tydllparamblock * data, XDLLProcTable * proctable) {
	Handle myInfo;
	myInfoStruct * info;

	if (InitMyCount(proctable, &myInfo)) {
		info = (myInfoStruct *) ((*(proctable->xMemLock)) (myInfo));
		++info->count;

		data->resultdata = info->count;
		data->resultsize = sizeof(long);

		(*(proctable->xMemUnlock)) (myInfo);

		return (TRUE);
		}

	strcpy (data->errormessage, "Error: could not init database entry");
	return (FALSE);
	}


BOOL CALLBACK DllEntryPoint(HINSTANCE hinstDLL,  // DLL module handle
    DWORD fdwReason,                    // reason called 
    LPVOID lpvReserved)                 // reserved 
	{  
    switch (fdwReason) 
		{ 
        // The DLL is loading due to process 
        // initialization or a call to LoadLibrary. 
 
        case DLL_PROCESS_ATTACH: 
 
            break; 
 
        // The attached process creates a new thread. 
 
        case DLL_THREAD_ATTACH: 
            break; 
 
        // The thread of the attached process terminates.
 
        case DLL_THREAD_DETACH: 
            break; 
 
        // The DLL is unloading from a process due to 
        // process termination or a call to FreeLibrary. 
 
        case DLL_PROCESS_DETACH: 
  
            break; 
 
        default: 
          break; 
		} 
 
    return (TRUE); 
    UNREFERENCED_PARAMETER(hinstDLL); 
    UNREFERENCED_PARAMETER(lpvReserved); 
	} 
